/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.patientcollect.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.TreeUtils;
import io.huimu.modules.patientcollect.dao.PatientCollectTreeDao;
import io.huimu.modules.patientcollect.dto.PatientCollectTreeDTO;
import io.huimu.modules.patientcollect.entity.PatientCollectTreeEntity;
import io.huimu.modules.patientcollect.service.PatientCollectTreeService;
import io.huimu.modules.security.user.SecurityUser;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PatientCollectTreeServiceImpl
extends BaseServiceImpl<PatientCollectTreeDao, PatientCollectTreeEntity>
implements PatientCollectTreeService {
    public void addTree(PatientCollectTreeDTO dto) {
        PatientCollectTreeEntity entity = (PatientCollectTreeEntity)ConvertUtils.sourceToTarget((Object)dto, PatientCollectTreeEntity.class);
        String id = entity.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.updateById((Object)entity);
        } else {
            if (!dto.getPid().equalsIgnoreCase("0")) {
                PatientCollectTreeEntity parent = (PatientCollectTreeEntity)((PatientCollectTreeDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)dto.getPid()));
                if (null != parent && StringUtils.isNotBlank((CharSequence)parent.getPids())) {
                    entity.setPids(parent.getPids() + "," + dto.getPid());
                } else {
                    entity.setPids(dto.getPid());
                }
            }
            entity.setCreateCode(SecurityUser.getEmployeeId());
            this.insert((Object)entity);
        }
    }

    public List<PatientCollectTreeDTO> getTree(String orgCode) {
        List list = ((PatientCollectTreeDao)this.baseDao).selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_code", (Object)orgCode)).eq((Object)"CREATE_CODE", (Object)SecurityUser.getEmployeeId())).orderByDesc((Object)"CREATE_DATE"));
        return TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, PatientCollectTreeDTO.class));
    }

    public List<String> getAllIdByTreeId(String treeId) {
        return ((PatientCollectTreeDao)this.baseDao).getAllIdByTreeId(treeId);
    }
}

