/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.doctorempower.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.huimu.common.exception.RenException;
import io.huimu.common.page.PageData;
import io.huimu.common.service.impl.BaseServiceImpl;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.HutoolSm4Utils;
import io.huimu.modules.doctorempower.dao.SysDoctorEmpowerDao;
import io.huimu.modules.doctorempower.dto.AddDoctorEmpowerDTO;
import io.huimu.modules.doctorempower.entity.SysDoctorEmpowerEntity;
import io.huimu.modules.doctorempower.entity.SysDoctorEmpowerRecordEntity;
import io.huimu.modules.doctorempower.service.SysDoctorEmpowerRecordService;
import io.huimu.modules.doctorempower.service.SysDoctorEmpowerService;
import io.huimu.modules.doctorempower.vo.DoctorEmpowerVO;
import io.huimu.modules.security.user.SecurityUser;
import io.huimu.modules.sys.dto.SysUserDTO;
import io.huimu.modules.sys.enums.UserStatusEnum;
import io.huimu.modules.sys.service.SysUserService;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDoctorEmpowerServiceImpl
extends BaseServiceImpl<SysDoctorEmpowerDao, SysDoctorEmpowerEntity>
implements SysDoctorEmpowerService {
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysDoctorEmpowerRecordService recordService;

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(AddDoctorEmpowerDTO dto) {
        SysUserDTO user = this.sysUserService.getByEmployeeId(dto.getEmployeeId());
        if (user == null) {
            throw new RenException(10004);
        }
        if (!HutoolSm4Utils.matches((String)dto.getPassword(), (String)user.getPassword())) {
            throw new RenException(10004);
        }
        if (user.getStatus().intValue() == UserStatusEnum.DISABLE.value()) {
            throw new RenException(10005);
        }
        ((SysDoctorEmpowerDao)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)dto.getEmployeeId()));
        SysDoctorEmpowerEntity entity = (SysDoctorEmpowerEntity)ConvertUtils.sourceToTarget((Object)dto, SysDoctorEmpowerEntity.class);
        entity.setSqUserName(user.getRealName());
        entity.setCreateName(SecurityUser.getUser().getRealName());
        if (null != dto.getToUsers() && dto.getToUsers().size() > 0) {
            entity.setToUser(StringUtils.join((Iterable)dto.getToUsers(), (String)","));
            entity.setToUserName(StringUtils.join((Iterable)this.sysUserService.getUserNameList(dto.getToUsers()), (String)","));
            SysDoctorEmpowerRecordEntity recordEntity = (SysDoctorEmpowerRecordEntity)ConvertUtils.sourceToTarget((Object)entity, SysDoctorEmpowerRecordEntity.class);
            recordEntity.setId(null);
            this.recordService.insert((Object)recordEntity);
        }
        this.insert((Object)entity);
    }

    public DoctorEmpowerVO getEmpowerInfo(String employeeId) {
        SysDoctorEmpowerEntity entity = (SysDoctorEmpowerEntity)((SysDoctorEmpowerDao)this.baseDao).selectOne((Wrapper)new QueryWrapper().eq((Object)"EMPLOYEE_ID", (Object)employeeId));
        DoctorEmpowerVO vo = (DoctorEmpowerVO)ConvertUtils.sourceToTarget((Object)entity, DoctorEmpowerVO.class);
        if (null != entity && StringUtils.isNotBlank((CharSequence)entity.getToUser())) {
            vo.setToUsers(Arrays.asList(entity.getToUser().split(",")));
        }
        return vo;
    }

    public SysUserDTO getMainDoctorSign(String operaPatientId) {
        String employeeId = "";
        if (StringUtils.isNotEmpty((CharSequence)employeeId)) {
            SysUserDTO dto = this.sysUserService.getByEmployeeId(employeeId);
            if (null == dto) {
                throw new RenException("\u4e3b\u5200\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u4e3b\u5200\u5de5\u53f7\uff1a" + employeeId);
            }
            Integer count = ((SysDoctorEmpowerDao)this.baseDao).selectSqCount(employeeId, SecurityUser.getUser().getEmployeeId());
            if (count > 0) {
                if (StringUtils.isEmpty((CharSequence)dto.getSignUrl())) {
                    throw new RenException("\u8bf7\u4e3b\u5200\u5b8c\u6210\u7b7e\u540d\u4fe1\u606f,\u4e3b\u5200\u5de5\u53f7\uff1a" + employeeId);
                }
                return dto;
            }
            throw new RenException("\u4e0d\u5b58\u5728\u6709\u6548\u7684\u6388\u6743\u65f6\u95f4\u6bb5\uff0c\u8bf7\u8054\u7cfb\u4e3b\u5200,\u4e3b\u5200\u5de5\u53f7:" + employeeId);
        }
        throw new RenException("\u8be5\u624b\u672f\u65e0\u6cd5\u67e5\u8be2\u4e3b\u5200\u4fe1\u606f");
    }

    public PageData getSqPage(Map<String, Object> params) {
        return this.recordService.getSqPage(params);
    }

    public PageData getBsqPage(Map<String, Object> params) {
        return this.recordService.getBsqPage(params);
    }
}

