/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.ConvertUtils;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.DictOperaSortDTO;
import io.huimu.modules.dict.entity.DictOperaSortEntity;
import io.huimu.modules.dict.param.DictOperaSortPageParam;
import io.huimu.modules.dict.service.DictOperaSortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/opera/sort"})
@Api(tags={"\u5c48\u5149\u624b\u672f\u6392\u5e8f\u5b57\u5178\u7ba1\u7406"})
public class DictOperaSortController {
    @Autowired
    private DictOperaSortService dictOperaSortService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=DictOperaSortPageParam.class)
    public Result<PageData<DictOperaSortDTO>> page(@RequestBody EncryptedReq<DictOperaSortPageParam> req) throws IllegalAccessException {
        DictOperaSortPageParam dto = (DictOperaSortPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.dictOperaSortService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u4fdd\u5b58")
    @DecryptAndVerify(decryptedClass=DictOperaSortDTO.class)
    @LogOperation(value="\u4fdd\u5b58", module="\u5c48\u5149\u624b\u672f\u6392\u5e8f\u5b57\u5178\u7ba1\u7406", operationType=1)
    public Result save(@RequestBody EncryptedReq<DictOperaSortDTO> req) {
        DictOperaSortDTO dto = (DictOperaSortDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dictOperaSortService.save((DictOperaSortEntity)ConvertUtils.sourceToTarget((Object)dto, DictOperaSortEntity.class));
        return new Result();
    }

    @PostMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539")
    @DecryptAndVerify(decryptedClass=DictOperaSortDTO.class)
    @LogOperation(value="\u4fee\u6539", module="\u5c48\u5149\u624b\u672f\u6392\u5e8f\u5b57\u5178\u7ba1\u7406", operationType=2)
    public Result update(@RequestBody EncryptedReq<DictOperaSortDTO> req) {
        DictOperaSortDTO dto = (DictOperaSortDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.dictOperaSortService.update((DictOperaSortEntity)ConvertUtils.sourceToTarget((Object)dto, DictOperaSortEntity.class));
        return new Result();
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u5220\u9664", module="\u5c48\u5149\u624b\u672f\u6392\u5e8f\u5b57\u5178\u7ba1\u7406", operationType=3)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        this.dictOperaSortService.deleteById((Serializable)((Object)dto.getId()));
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        IdParam dto = (IdParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        DictOperaSortEntity en = (DictOperaSortEntity)this.dictOperaSortService.selectById((Serializable)((Object)dto.getId()));
        return new Result().ok(req.getEncode(), ConvertUtils.sourceToTarget((Object)en, DictOperaSortDTO.class));
    }

    @PostMapping(value={"getList"})
    @ApiOperation(value="\u83b7\u53d6\u83b7\u53d6\u5217\u8868")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getList(@RequestBody EncryptedReq<NoParam> req) {
        List list = this.dictOperaSortService.getList();
        return new Result().ok(req.getEncode(), (Object)list);
    }
}

