/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dict.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.AddGroup;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.common.validator.group.UpdateGroup;
import io.huimu.modules.dict.dto.ExeVersionDTO;
import io.huimu.modules.dict.param.GetExeVersionPageParam;
import io.huimu.modules.dict.service.DictServerExeVersionService;
import io.huimu.modules.jsversion.param.ChangeOpenParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/exe/version"})
@Api(tags={"\u672c\u5730\u670d\u52a1exe\u7248\u672c\u7ba1\u7406"})
public class DictExeVersionController {
    @Autowired
    private DictServerExeVersionService versionService;

    @PostMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetExeVersionPageParam.class)
    public Result<PageData<ExeVersionDTO>> page(@RequestBody EncryptedReq<GetExeVersionPageParam> req) throws IllegalAccessException {
        GetExeVersionPageParam dto = (GetExeVersionPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        PageData page = this.versionService.page(MapUtils.object2Map((Object)dto));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"pushVersion"})
    @ApiOperation(value="\u53d1\u5e03\u7248\u672c")
    @LogOperation(value="\u53d1\u5e03\u7248\u672c", module="\u672c\u5730\u670d\u52a1exe\u7248\u672c\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=ExeVersionDTO.class)
    public Result pushVersion(@RequestBody EncryptedReq<ExeVersionDTO> req) throws IOException {
        ExeVersionDTO dto = (ExeVersionDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{AddGroup.class, DefaultGroup.class});
        this.versionService.pushVersion(dto);
        return new Result();
    }

    @PostMapping(value={"updateVersion"})
    @ApiOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9")
    @LogOperation(value="\u4fee\u6539\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u672c\u5730\u670d\u52a1exe\u7248\u672c\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ExeVersionDTO.class)
    public Result updateVersion(@RequestBody EncryptedReq<ExeVersionDTO> req) {
        ExeVersionDTO dto = (ExeVersionDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{UpdateGroup.class, DefaultGroup.class});
        this.versionService.updateVersion(dto);
        return new Result();
    }

    @PostMapping(value={"getInfo"})
    @ApiOperation(value="\u83b7\u53d6\u53d1\u5e03\u7248\u672c\u8be6\u60c5")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result getInfo(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        ExeVersionDTO dto = this.versionService.getInfo(((IdParam)req.getData()).getId());
        return new Result().ok(req.getEncode(), (Object)dto);
    }

    @PostMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664")
    @LogOperation(value="\u5220\u9664\u53d1\u5e03\u7248\u672c\u5185\u5bb9", module="\u672c\u5730\u670d\u52a1exe\u7248\u672c\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delete(@RequestBody EncryptedReq<IdParam> req) {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        String id = ((IdParam)req.getData()).getId();
        this.versionService.deleteById((Serializable)((Object)id));
        return new Result();
    }

    @PostMapping(value={"changeStatus"})
    @ApiOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001")
    @LogOperation(value="\u4fee\u6539\u5f00\u542f\u72b6\u6001", module="\u672c\u5730\u670d\u52a1exe\u7248\u672c\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=ChangeOpenParam.class)
    public Result changeStatus(@RequestBody EncryptedReq<ChangeOpenParam> req) throws IOException {
        ValidatorUtils.validateEntity((Object)req.getData(), (Class[])new Class[0]);
        this.versionService.changeStatus((ChangeOpenParam)req.getData());
        return new Result();
    }

    @PostMapping(value={"getExePath"})
    @ApiOperation(value="\u83b7\u53d6\u5f00\u542f\u7684exe\u6587\u4ef6\u8def\u5f84")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result getExePath(@RequestBody EncryptedReq<NoParam> req) {
        String path = this.versionService.getExePath();
        return new Result().ok(req.getEncode(), (Object)path);
    }
}

