/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.dataextract.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.dataextract.param.DataExtractParam;
import io.huimu.modules.dataextract.param.GetExtractDataParam;
import io.huimu.modules.dataextract.service.DataExtractService;
import io.huimu.modules.dataextract.vo.ExtractDataVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/data/extract"})
@Api(tags={"\u6570\u636e\u6838\u67e5"})
public class DataExtractController {
    @Autowired
    private DataExtractService dataExtractService;

    @PostMapping(value={"saveExtractData"})
    @ApiOperation(value="\u4fdd\u5b58\u6838\u67e5\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u6838\u67e5\u6570\u636e", module="\u6570\u636e\u6838\u67e5", operationType=1)
    @DecryptAndVerify(decryptedClass=DataExtractParam.class)
    public Result saveExtractData(@RequestBody EncryptedReq<DataExtractParam> req) {
        DataExtractParam dto = (DataExtractParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        this.dataExtractService.saveExtractData(dto);
        return new Result();
    }

    @PostMapping(value={"getExtractData"})
    @ApiOperation(value="\u83b7\u53d6\u6838\u67e5\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetExtractDataParam.class)
    public Result getExtractData(@RequestBody EncryptedReq<GetExtractDataParam> req) {
        GetExtractDataParam dto = (GetExtractDataParam)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        ExtractDataVO vo = this.dataExtractService.getExtractData(dto);
        return new Result().ok(req.getEncode(), (Object)vo);
    }
}

