/*
 * Decompiled with CFR 0.152.
 */
package io.huimu.modules.bdform.controller;

import io.huimu.common.annotation.DecryptAndVerify;
import io.huimu.common.annotation.LogOperation;
import io.huimu.common.page.PageData;
import io.huimu.common.param.ArchiveIdParam;
import io.huimu.common.param.FormIdParam;
import io.huimu.common.param.IdParam;
import io.huimu.common.param.MenuIdParam;
import io.huimu.common.param.NoParam;
import io.huimu.common.utils.EncryptedReq;
import io.huimu.common.utils.MapUtils;
import io.huimu.common.utils.Result;
import io.huimu.common.validator.AssertUtils;
import io.huimu.common.validator.ValidatorUtils;
import io.huimu.common.validator.group.DefaultGroup;
import io.huimu.modules.bdform.dto.AddBdFormDTO;
import io.huimu.modules.bdform.dto.BdTemplateDTO;
import io.huimu.modules.bdform.dto.CancelVerifyFormDTO;
import io.huimu.modules.bdform.dto.ChangeFormHcDTO;
import io.huimu.modules.bdform.dto.GetFormDataDTO;
import io.huimu.modules.bdform.dto.GetLastWjdcDataJsonDTO;
import io.huimu.modules.bdform.dto.GetTableTemplateDTO;
import io.huimu.modules.bdform.dto.PrintFormDTO;
import io.huimu.modules.bdform.dto.SaveFormDataDTO;
import io.huimu.modules.bdform.dto.VerifyFormDTO;
import io.huimu.modules.bdform.param.GetBdExamInfo;
import io.huimu.modules.bdform.param.GetVerifyFormPageParam;
import io.huimu.modules.bdform.param.SendFormToWxParam;
import io.huimu.modules.bdform.param.SendWxOperaXzParam;
import io.huimu.modules.bdform.service.BdFormService;
import io.huimu.modules.bdform.vo.BdFormDataVO;
import io.huimu.modules.bdform.vo.BdFormVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bd/form"})
@Api(tags={"\u8868\u5355\u7ba1\u7406"})
public class BdFormController {
    @Autowired
    private BdFormService bdFormService;

    @PostMapping(value={"getListByMenuId"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355id\uff0c\u83b7\u53d6\u6a21\u677f\u5217\u8868")
    @DecryptAndVerify(decryptedClass=MenuIdParam.class)
    public Result<Map<String, List<BdTemplateDTO>>> getListByMenuId(@RequestBody EncryptedReq<MenuIdParam> req) {
        MenuIdParam param = (MenuIdParam)req.getData();
        AssertUtils.isBlank((String)param.getMenuId(), (String[])new String[]{"\u83dc\u5355Id"});
        Map resList = this.bdFormService.getListByMenuId(param.getMenuId(), param.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"getNoTypeListByMenuId"})
    @ApiOperation(value="\u6839\u636e\u83dc\u5355id\uff0c\u83b7\u53d6\u6a21\u677f\u5217\u8868,\u6ca1\u6709\u5206\u7c7b")
    @DecryptAndVerify(decryptedClass=NoParam.class)
    public Result<List<BdTemplateDTO>> getNoTypeListByMenuId(@RequestBody EncryptedReq<NoParam> req) {
        List resList = this.bdFormService.getNoTypeListByMenuId();
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"addForm"})
    @ApiOperation(value="\u6dfb\u52a0\u8868\u5355")
    @LogOperation(value="\u6dfb\u52a0\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=AddBdFormDTO.class)
    public Result addForm(@RequestBody EncryptedReq<AddBdFormDTO> req) {
        AddBdFormDTO dto = (AddBdFormDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.bdFormService.addForm(dto);
    }

    @PostMapping(value={"getFormList"})
    @ApiOperation(value="\u83b7\u53d6\u60a3\u8005\u8868\u5355\u5217\u8868")
    @DecryptAndVerify(decryptedClass=ArchiveIdParam.class)
    public Result getFormList(@RequestBody EncryptedReq<ArchiveIdParam> req) {
        ArchiveIdParam data = (ArchiveIdParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        List resList = this.bdFormService.getFormList(data);
        return new Result().ok(req.getEncode(), (Object)resList);
    }

    @PostMapping(value={"delForm"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355")
    @LogOperation(value="\u5220\u9664\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=3)
    @DecryptAndVerify(decryptedClass=IdParam.class)
    public Result delForm(@RequestBody EncryptedReq<IdParam> req) {
        IdParam param = (IdParam)req.getData();
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"\u8868\u5355id"});
        return this.bdFormService.delForm(param.getId());
    }

    @PostMapping(value={"getFormData"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetFormDataDTO.class)
    public Result getFormData(@RequestBody EncryptedReq<GetFormDataDTO> req) throws InterruptedException {
        GetFormDataDTO data = (GetFormDataDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[0]);
        BdFormDataVO vo = this.bdFormService.getFormData(data.getPatientId(), data.getFormId(), data.getOrgCode());
        return new Result().ok(req.getEncode(), (Object)vo);
    }

    @PostMapping(value={"saveFormData"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u8868\u5355\u6570\u636e", module="\u8868\u5355\u7ba1\u7406", operationType=1)
    @DecryptAndVerify(decryptedClass=SaveFormDataDTO.class)
    public Result saveFormData(@RequestBody EncryptedReq<SaveFormDataDTO> req) throws IOException {
        SaveFormDataDTO dto = (SaveFormDataDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.bdFormService.saveFormData(dto);
    }

    @PostMapping(value={"getVerifyFormPage"})
    @ApiOperation(value="\u83b7\u53d6\u5ba1\u6838\u7684\u8868\u5355\u5206\u9875")
    @DecryptAndVerify(decryptedClass=GetVerifyFormPageParam.class)
    public Result<PageData<BdFormVO>> getVerifyFormPage(@RequestBody EncryptedReq<GetVerifyFormPageParam> req) throws IllegalAccessException {
        GetVerifyFormPageParam params = (GetVerifyFormPageParam)req.getData();
        ValidatorUtils.validateEntity((Object)params, (Class[])new Class[]{DefaultGroup.class});
        PageData page = this.bdFormService.getVerifyFormPage(MapUtils.object2Map((Object)params));
        return new Result().ok(req.getEncode(), (Object)page);
    }

    @PostMapping(value={"verifyForm"})
    @ApiOperation(value="\u5ba1\u6838\u8868\u5355")
    @LogOperation(value="\u5ba1\u6838\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=VerifyFormDTO.class)
    public Result verifyForm(@RequestBody EncryptedReq<VerifyFormDTO> req) {
        VerifyFormDTO dto = (VerifyFormDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.bdFormService.verifyForm(dto);
    }

    @PostMapping(value={"cancelVerifyForm"})
    @ApiOperation(value="\u53d6\u6d88\u5ba1\u6838\u8868\u5355")
    @LogOperation(value="\u53d6\u6d88\u5ba1\u6838\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=2)
    @DecryptAndVerify(decryptedClass=CancelVerifyFormDTO.class)
    public Result cancelVerifyForm(@RequestBody EncryptedReq<CancelVerifyFormDTO> req) {
        CancelVerifyFormDTO dto = (CancelVerifyFormDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[]{DefaultGroup.class});
        return this.bdFormService.cancelVerifyForm(dto);
    }

    @PostMapping(value={"getFormSaveRecordList"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u4fdd\u5b58\u8bb0\u5f55\u5217\u8868")
    @DecryptAndVerify(decryptedClass=FormIdParam.class)
    public Result getFormSaveRecordList(@RequestBody EncryptedReq<FormIdParam> req) {
        FormIdParam param = (FormIdParam)req.getData();
        AssertUtils.isBlank((String)param.getFormId(), (String[])new String[]{"\u8868\u5355"});
        List recordList = this.bdFormService.getFormSaveRecordList(param.getFormId());
        return new Result().ok(req.getEncode(), (Object)recordList);
    }

    @PostMapping(value={"getFormSaveRecordData"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355\u4fdd\u5b58\u8bb0\u5f55\u6570\u636e")
    @DecryptAndVerify(decryptedClass=FormIdParam.class)
    public Result getFormSaveRecordData(@RequestBody EncryptedReq<FormIdParam> req) {
        FormIdParam param = (FormIdParam)req.getData();
        AssertUtils.isBlank((String)param.getFormId(), (String[])new String[]{"\u8868\u5355"});
        AssertUtils.isBlank((String)param.getId(), (String[])new String[]{"id"});
        String content = this.bdFormService.getFormSaveRecordData(param.getId(), param.getFormId());
        return new Result().ok(req.getEncode(), (Object)content);
    }

    @PostMapping(value={"getTableTemplate"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u8868\u5355\u6a21\u677f\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=GetTableTemplateDTO.class)
    public Result getTableTemplate(@RequestBody EncryptedReq<GetTableTemplateDTO> req) {
        GetTableTemplateDTO dto = (GetTableTemplateDTO)req.getData();
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        List list = this.bdFormService.getTableTemplate(dto.getTemplateCode(), dto.getTypeCode());
        return new Result().ok(req.getEncode(), (Object)list);
    }

    @PostMapping(value={"lockTable"})
    @ApiOperation(value="\u9501\u5b9a\u8868\u5355")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u9501\u5b9a\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=2)
    public Result lockTable(@RequestBody EncryptedReq<IdParam> req) {
        IdParam data = (IdParam)req.getData();
        return this.bdFormService.lockTable(data.getId());
    }

    @PostMapping(value={"unlockTable"})
    @ApiOperation(value="\u89e3\u9501\u8868\u5355")
    @DecryptAndVerify(decryptedClass=IdParam.class)
    @LogOperation(value="\u89e3\u9501\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=2)
    public Result unlockTable(@RequestBody EncryptedReq<IdParam> req) {
        IdParam data = (IdParam)req.getData();
        return this.bdFormService.unlockTable(data.getId());
    }

    @PostMapping(value={"getBdExamInfo"})
    @ApiOperation(value="\u6839\u636e\u68c0\u67e5\u53f7\u83b7\u53d6\u60a3\u8005\u57fa\u672c\u4fe1\u606f")
    @DecryptAndVerify(decryptedClass=GetBdExamInfo.class)
    public Result getBdExamInfo(@RequestBody EncryptedReq<GetBdExamInfo> req) {
        GetBdExamInfo data = (GetBdExamInfo)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        Map dataVO = this.bdFormService.getBdExamInfo(data.getExamNo());
        return new Result().ok(req.getEncode(), (Object)dataVO);
    }

    @PostMapping(value={"sendWxOperaXz"})
    @ApiOperation(value="\u63a8\u9001\u5fae\u4fe1\u624b\u672f\u987b\u77e5\u8868\u5355")
    @DecryptAndVerify(decryptedClass=SendWxOperaXzParam.class)
    public Result sendWxOperaXz(@RequestBody EncryptedReq<SendWxOperaXzParam> req) {
        SendWxOperaXzParam data = (SendWxOperaXzParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.bdFormService.sendWxOperaXz(data);
        return new Result();
    }

    @PostMapping(value={"sendFormToWx"})
    @ApiOperation(value="\u63a8\u9001\u8868\u5355\u5230\u5fae\u4fe1")
    @DecryptAndVerify(decryptedClass=SendFormToWxParam.class)
    public Result sendFormToWx(@RequestBody EncryptedReq<SendFormToWxParam> req) {
        SendFormToWxParam data = (SendFormToWxParam)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.bdFormService.sendFormToWx(data);
        return new Result();
    }

    @PostMapping(value={"changeFormHc"})
    @ApiOperation(value="\u6539\u53d8\u8868\u5355\u6838\u67e5\u72b6\u6001")
    @DecryptAndVerify(decryptedClass=ChangeFormHcDTO.class)
    @LogOperation(value="\u6838\u67e5\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=2)
    public Result changeFormHc(@RequestBody EncryptedReq<ChangeFormHcDTO> req) {
        ChangeFormHcDTO data = (ChangeFormHcDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        this.bdFormService.changeFormHc(data);
        return new Result();
    }

    @PostMapping(value={"getLastWjdcDataJson"})
    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u95ee\u5377json\u6570\u636e")
    @DecryptAndVerify(decryptedClass=GetLastWjdcDataJsonDTO.class)
    public Result getLastWjdcDataJson(@RequestBody EncryptedReq<GetLastWjdcDataJsonDTO> req) {
        GetLastWjdcDataJsonDTO data = (GetLastWjdcDataJsonDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        String str = this.bdFormService.getLastWjdcDataJson(data);
        return new Result().ok((Object)str);
    }

    @PostMapping(value={"printForm"})
    @ApiOperation(value="\u6253\u5370\u8868\u5355")
    @DecryptAndVerify(decryptedClass=PrintFormDTO.class)
    @LogOperation(value="\u6253\u5370\u8868\u5355", module="\u8868\u5355\u7ba1\u7406", operationType=1)
    public Result printForm(@RequestBody EncryptedReq<PrintFormDTO> req) {
        PrintFormDTO data = (PrintFormDTO)req.getData();
        ValidatorUtils.validateEntity((Object)data, (Class[])new Class[]{DefaultGroup.class});
        return new Result();
    }
}

